nuc_master = read.csv('~/data/nuc_master.csv')
nuc_master_sub = subset(nuc_master,cac_c40 > quantile(nuc_master$cac_c40,0.25) & wt_c40 > quantile(nuc_master$wt_c40,0.25) )

cac_slow_mtx_list = readRDS('~/data/cac_slow_mtx_list.RDS')
slow_mtx_list = list(cac_slow_mtx_list[[1]][[1]],
                     cac_slow_mtx_list[[1]][[2]],
                     cac_slow_mtx_list[[1]][[3]],
                     cac_slow_mtx_list[[1]][[4]],
                     cac_slow_mtx_list[[1]][[5]])
for (i in 2:10) {
  for (j in 1:5) {
    slow_mtx_list[[j]] = slow_mtx_list[[j]] + cac_slow_mtx_list[[i]][[j]]
  }

}


slow_mtx.df = data.frame('zone1'=rep(0,5),'zone2'=rep(0,5),'zone3'=rep(0,5))
for (i in 1:5) {
  slow_mtx.df[i,1] = sum(slow_mtx_list[[i]][170:250,235:270])
  slow_mtx.df[i,2] = sum(slow_mtx_list[[i]][170:250,330:375])
  slow_mtx.df[i,3] = sum(slow_mtx_list[[i]][70:110,283:317])
  
}
#repeat for slow 

#panel A example
a = slow_mtx_list[[2]][30:230,100:500] 
dens_dot_plot(a[nrow(a):1,],  z_min = 0, z_max =700, plot_title='',x_label='Distance from nucleosome dyad (bp)',y_label='Fragment length (bp)',x_axt = 'n', y_axt = 'n',lowCol = 'slateblue2', medCol = "yellow", highCol = "red", numColors = 50) #adjust z range for each experiment
axis(side=1,labels=F, tick=T,at=c(-150,0,150)) #x-axis
mtext(at=c(-150,0,150), text=c(-150,0,150), side=1, line=0.8, cex=1)
axis(side = 2,labels = F, tick = T, at = c(20,70,120,170))
mtext(at=c(20,70,120,170), text=c(50,100,150,200), side=2, line=0.8, cex=1)

png(file = '~/data/figure/nuc_to_subnuc_ratio.png', width =5, height = 4.5, units = "in", res = 200, bg = "white", type = "cairo-png" )
par(mar = c(4,4,4,2), cex=1.5)
plot(c(1,2,3,4,5),slow_mtx.df$zone3/(slow_mtx.df$zone1 + slow_mtx.df$zone2+ slow_mtx.df$zone3),xaxt='n',xlab='',col='tomato3',pch=20,ylim=c(0.2,0.9),cex=1.2,ylab='N/(S1+S2+N)')
points(c(1,2,3,4,5),fast_mtx.df$zone3/(fast_mtx.df$zone1 + fast_mtx.df$zone2+ fast_mtx.df$zone3),col='forestgreen',pch=20,cex=1.2)
axis(side = 1,at = c(1,2,3,4,5),labels = c('Pulse',"10'","15'","20'","40'"))
legend('bottomright',c('Fast nucleosome','Slow nucleosome'),col=c('forestgreen','tomato3'),pch=c(20,20),box.lwd = 0,box.col = "transparent",bg = "transparent",cex=0.6)
dev.off()

